define(['app', 'angular'], function (app, angular) {

	app.directive('inputCheckbox', function ($compile) {

        return {
            restrict: 'E',
            require: 'ngModel',
            scope: {
                'label': '@',
                'name': '@',
                'ngDisabled': '=',
                'ngRequired': '=',
                'ngModel': '=',
                'tableHeaderId': '@',
                'selectedFieldName': '@'
            },
            link: function (scope, elems, attrs, ngModelCtrl) {
                if (_.isEmpty(scope.selectedFieldName)) {
                    scope.selectedFieldName = 'selected';
                }

                if (scope.ngRequired) {
                    var validator = function (newVal) {
                        return newVal;
                    };

                    ngModelCtrl.$parsers.push(validator);
                    ngModelCtrl.$formatters.push(validator);
                }

                scope.onChange = function (checkModel) {
                    if (scope.ngRequired) {
                        validator(checkModel[scope.selectedFieldName]);
                    }
                };
            },
            template: function (elems, attrs) {
                var labelFieldName = attrs.labelFieldName || 'label';
                var selectedFieldName = attrs.selectedFieldName || 'selected';

                var labelContent;
                if (attrs.labelCapitalize === 'true') {
                    labelContent = '{{ngModel.' + labelFieldName + ' | capitalize}}';
                } else {
                    labelContent = '{{ngModel.' + labelFieldName + '}}';
                }

                var templateStr =
                    '<div form-control-wrapper> \
                        <label ng-if="!tableHeaderId" class="input-checkbox-label"> \
                            <span class="input-checkbox-legend" required-field is-required="ngRequired">{{label}}</span> \
                        </label> \
                        <div class="input-checkbox"> \
                        <input type="checkbox" \
                            ng-attr-id="{{name}}" \
                            ng-attr-name="{{name}}" \
                            ng-model="ngModel.' + selectedFieldName + '" \
                            aria-checked="{{ngModel.' + selectedFieldName + ' || false}}" \
                            ng-disabled="ngDisabled" \
                            ng-change="onChange(ngModel)"> \
                        <label for="{{name}}" class="input-checkbox-label-content">' + labelContent + '</label> \
					</div> \
				</div>';

                templateStr = templateStr.replace(/>\s+</g, '><').replace(/\s+/g, ' ');

                return templateStr;
            }
        };
    });

});